﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class SubscriptionDB
    {
        public static Subscription GetItem(Guid SubscriptionID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((SubscriptionID != Guid.Empty && SubscriptionID != null) ? SubscriptionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<Subscription>("spGetSubscription", parameters);
        }

        public static List<Subscription> GetList(Guid SubscriptionID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((SubscriptionID != Guid.Empty && SubscriptionID != null) ? SubscriptionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<Subscription>("spGetSubscription", parameters);
        }

        public static DataTable GetDataTable(Guid SubscriptionID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((SubscriptionID != Guid.Empty && SubscriptionID != null) ? SubscriptionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetSubscription", parameters);
        }

        public static DataSet GetDataSet(Guid SubscriptionID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((SubscriptionID != Guid.Empty && SubscriptionID != null) ? SubscriptionID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetSubscription", parameters);
        }

        public static void Save(Subscription myNewsLetter)
        {
            myNewsLetter.Mode = ((myNewsLetter.UniqueID != Guid.Empty && myNewsLetter.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myNewsLetter.UniqueID = ((myNewsLetter.UniqueID != Guid.Empty && myNewsLetter.UniqueID != null) ? myNewsLetter.UniqueID : Guid.NewGuid());
            if (myNewsLetter.Mode == GlobalConfigurations.Mode.Insert)
            {
                myNewsLetter.IsActive = true;
                //myOrders.IsDeleted = false;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@SubscriptionID", myNewsLetter.UniqueID));
            parameters.Add(new SqlParameter("@Salutaion", (string.IsNullOrEmpty(myNewsLetter.Salutaion) ? (object)DBNull.Value : myNewsLetter.Salutaion)));
            parameters.Add(new SqlParameter("@FullName", (string.IsNullOrEmpty(myNewsLetter.FullName) ? (object)DBNull.Value : myNewsLetter.FullName)));
            parameters.Add(new SqlParameter("@Email", (string.IsNullOrEmpty(myNewsLetter.Email) ? (object)DBNull.Value : myNewsLetter.Email)));
            parameters.Add(new SqlParameter("@CompanyName", (string.IsNullOrEmpty(myNewsLetter.CompanyName) ? (object)DBNull.Value : myNewsLetter.CompanyName)));
            parameters.Add(new SqlParameter("@IsSubscribed", myNewsLetter.IsSubscribed));
            parameters.Add(new SqlParameter("@IsActive", myNewsLetter.IsActive));

            SQLHelper.ExecuteQuery("spAddOrUpdateSubscription", parameters);
        }
    }
}
